### Name: hist.ab
### Title: Histogram routines to help compute the cross-correlation between
###   a pair of spike trains.
### Aliases: hist.ab histbi.ab count.nab test.count.hist2.nab
###   test.count.hist.nab test.hist.ab test.histograms.versus.r
### Keywords: math

### ** Examples


stopifnot(isTRUE(all.equal.numeric(
  histbi.ab(c(0), c(-2, -2, 0, 0, 1, 1,1, 1.8,2), tmax=2, nbins=4),
  c(2,0,2,5),
  check.attributes=FALSE)))
stopifnot(identical(TRUE, all.equal.numeric(
  hist.ab(c(0), c(-2, -2, 0, 0, 1, 1,1, 1.8,  2), tmax=2, nbins=4),
  c(2,0,3,4),
  check.attributes=FALSE)))
 
test.hist.ab()

## Not run: 
##D test.histograms.versus.r()
##D test.count.hist.nab()
##D test.count.hist.nab(s)
##D test.count.hist2.nab(s)
## End(Not run)



