### Name: jay.read.spikes
### Title: Read in the .txt file from Neuroexplorer and create a "spikes"
###   data structure.
### Aliases: jay.read.spikes
### Keywords: math

### ** Examples

data.file <- system.file("examples", "P9_CTRL_MY1_1A.txt",
                         package = "sjemea")
s <- jay.read.spikes( data.file)
fourplot(s)
s <- jay.read.spikes( data.file, beg=400, end=700)
fourplot(s)
## Not run: 
##D s <- jay.read.spikes("/home/stephen/ms/jay/p9data.txt")
##D fourplot(s)                             #summary plot.
##D s$mi <- make.mi(s)
##D show.prob.t.r(s)                        #conditional distributions.
## End(Not run)

## Not run: crosscorrplots(s, autocorr=T, tmax=3, nbins=100,
##D                xcorr.nrows=3, xcorr.ncols=3) #plot autocorrs on screen
##D 
##D ## Plotting just one cross-correlogram is a slightly different matter:
##D xcorr.plot( s$spikes[[1]], s$spikes[[2]], "1 v 2")
## End(Not run)




