### Name: networkspikes
### Title: Compute network spikes
### Aliases: compute.ns show.ns
### Keywords: Network spikes, MEA analysis

### ** Examples

data.file <- system.file("examples", "TC89_DIV15_A.nexTimestamps",
                         package = "sjemea")
s <- sanger.read.spikes( data.file, beg=400, end=700)
s$ns <- compute.ns(s, ns.T=0.003, ns.N=10,sur=100)
plot(s$ns)
plot(s$ns, xlim=c(450, 500))

plot(s$ns$mean)                         #show mean NS.
summary(s$ns)
s$ns$brief




